/*Copyright (C) 2007 Cassarin-Grand Arthur (Zoloom)

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA. */

#include "Fenp.h"
#include "Fent.h"
#include "Fenconfig.h"
#include "Fennew.h"
#include "Fenupscript.h"

#define ID_RUNSCRIPT 100
#define ID_UPSCRIPT 101
#define ID_CONFIG 102
#define ID_LANGUE 103
#define ID_FCD 104
#define ID_FMV 105
#define ID_FCOPY 106
#define ID_FRM 107
#define ID_SPX 108
#define ID_ASKV 109
#define ID_ASKCD 110
#define ID_CHECKCD 111
#define ID_STARTEXE 112
#define ID_ADDSTARTER 113
#define ID_CPX 114
#define ID_SIMREBOOT 115
#define ID_ASSIGNWINE 116
#define ID_SETOS 117
#define ID_REGEDIT 118
#define ID_MESSAGE 119
#define ID_WARNING 120
#define ID_QUESTION 121
#define ID_CHAMP 122
#define ID_ERROR 123
#define ID_SETSOUND 124
#define ID_SETMANAGE 125
#define ID_SETDXGRAB 126
#define ID_SETGLSL 127
#define ID_BROWSFILE 128
#define ID_DOWNLOAD 129

using namespace std;

Fenp::Fenp() : wxFrame(NULL,wxID_ANY,_T("PlayOnLinux Script Creator"),wxDefaultPosition, wxSize(800,600))
{
	
	wxBeginBusyCursor(wxHOURGLASS_CURSOR);
	SetBackgroundColour(wxSystemSettings::GetColour(wxSYS_COLOUR_3DFACE));
	
	wxIcon icoFenp(_T("images/playonlinux2.png")); //declaration de l'icone
	SetIcon(icoFenp); //on le lie a la fenetre
	
	CreateMenuFenp(); //création des menus
	
	wxToolBar* toolBarFenp = CreateToolBar( wxTB_FLAT|wxTB_HORIZONTAL);
	wxBitmap *bitNewTool = new wxBitmap(_T("images/document-new.png"));
	toolBarFenp->AddTool(wxID_NEW, _("New"), *bitNewTool, _("New File"), wxITEM_NORMAL);
	wxBitmap *bitOpenTool = new wxBitmap(_T("images/folder.png"));
	toolBarFenp->AddTool(wxID_OPEN, _("Open"), *bitOpenTool, _("Open a File"), wxITEM_NORMAL);
	wxBitmap *bitSaveTool = new wxBitmap(_T("images/document-save.png"));
	toolBarFenp->AddTool(wxID_SAVE, _("Save"), *bitSaveTool, _("Save"), wxITEM_NORMAL);
	wxBitmap *bitSaveAsTool = new wxBitmap(_T("images/document-save-as.png"));
	toolBarFenp->AddTool(wxID_SAVEAS, _("Save as"), *bitSaveAsTool, _("Save as"), wxITEM_NORMAL);
	wxBitmap *bitRunScript = new wxBitmap(_T("images/runG.png"));
	toolBarFenp->AddSeparator();
	toolBarFenp->AddTool(ID_RUNSCRIPT, _("Run the current script"), *bitRunScript, _("Run the current script"), wxITEM_NORMAL);
	
	txtcMainBuffer = new wxTextCtrl(this, -1, "", wxDefaultPosition, wxSize(800,800), wxTE_MULTILINE);
				
	CreateStatusBar();
	wxEndBusyCursor();
		
}

Fenp::~Fenp()
{
	
}

void Fenp::CreateMenuFenp() //instance de création de menu
{
	wxMenuBar* menuBarFenp = new wxMenuBar;
	
	menuFile = new wxMenu;
	menuFile->Append(wxID_NEW, _("&New File"), _("New File"));
	menuFile->Append(wxID_OPEN, _("&Open a File"), _("Open a file/script"));
	menuFile->Append(wxID_SAVE, _("&Save"));
	menuFile->Append(wxID_SAVEAS, _("&Save as..."));
	menuFile->AppendSeparator();
	menuFile->Append(wxID_EXIT, _("&Quit"));
	menuBarFenp->Append(menuFile, _("&File"));
	
	menuExecution = new wxMenu;
	wxMenuItem *runScriptObjet = new wxMenuItem(menuExecution, ID_RUNSCRIPT, _("&Run the script"));
	runScriptObjet->SetBitmap(wxBitmap(_T("images/run.png")));
	menuExecution->Append(runScriptObjet);
	/*wxMenuItem *proposeScriptObjet = new wxMenuItem(menuExecution, ID_UPSCRIPT, _("&Purpose the script"));
	proposeScriptObjet->SetBitmap(wxBitmap(_T("images/go-up.png")));
	menuExecution->Append(proposeScriptObjet);*/
	menuBarFenp->Append(menuExecution, _("&Run"));
			
	subMenuFilesDirectory = new wxMenu;
	subMenuFilesDirectory->Append(ID_FCD, _("Change the current directory"));
	subMenuFilesDirectory->Append(ID_FMV, _("Move a file / directory"));
	subMenuFilesDirectory->Append(ID_FCOPY, _("Copy a file / directory"));
	subMenuFilesDirectory->Append(ID_FRM, _("Delete a file / directory"));
									
	subMenuWineVersions = new wxMenu;
	subMenuWineVersions->Append(ID_ASSIGNWINE, _("Assign a Wine version"));
	subMenuWineVersions->Append(ID_SETOS, _("Set a Windows OS"));
	subMenuWineVersions->Append(ID_SETSOUND, _("Set a sound driver"));
	subMenuWineVersions->Append(ID_SETMANAGE, _("Allow Wine to manage windows"));
	subMenuWineVersions->Append(ID_SETDXGRAB, _("Allow DirectX to catch cursor"));
	subMenuWineVersions->Append(ID_SETGLSL, _("Activate GLSL"));
	subMenuWineVersions->Append(ID_REGEDIT, _("Apply a registry file"));
								
	subMenuWinePrefixe = new wxMenu;
	subMenuWinePrefixe->Append(ID_CPX, _("Create a prefix"));
	subMenuWinePrefixe->Append(ID_SPX, _("Select a prefix"));
							   
	subMenuCDDVDROM = new wxMenu;
	subMenuCDDVDROM->Append(ID_ASKCD, _("Ask for CD-ROM"));
	subMenuCDDVDROM->Append(ID_CHECKCD, _("Check the CD-ROM"));
	
	subMenuGeneral = new wxMenu;
	subMenuGeneral->Append(ID_STARTEXE, _("Start an executable with Wine"));
	subMenuGeneral->Append(ID_ADDSTARTER, _("Add a launcher"));
	subMenuGeneral->Append(ID_SIMREBOOT, _("Simulate Windows reboot"));
	
	subMenuDialog = new wxMenu;
	subMenuDialog->Append(ID_MESSAGE, _("Show a message dialog"));
	subMenuDialog->Append(ID_WARNING, _("Show a warning dialog"));
	subMenuDialog->Append(ID_ERROR, _("Show an error dialog"));
	subMenuDialog->Append(ID_DOWNLOAD, _("Show a download dialog"));
	subMenuDialog->Append(ID_QUESTION, _("Ask a yes/no question"));
	subMenuDialog->Append(ID_CHAMP, _("Ask a value"));
	subMenuDialog->Append(ID_BROWSFILE, _("Ask a file path"));
			
	menuFonctions = new wxMenu;
	menuFonctions->AppendSubMenu(subMenuGeneral, _("General"));
	menuFonctions->AppendSubMenu(subMenuDialog, _("Dialogs"));
	menuFonctions->AppendSubMenu(subMenuFilesDirectory, _("Files and Directories"));
	menuFonctions->AppendSubMenu(subMenuWineVersions, _("Wine Configuration"));
	menuFonctions->AppendSubMenu(subMenuWinePrefixe, _("Wine Prefixes"));
	menuFonctions->AppendSubMenu(subMenuCDDVDROM, _("CD/DVD-ROM"));
	menuBarFenp->Append(menuFonctions, _("&Functions"));
		
	/*menuConfig = new wxMenu;
	wxMenuItem *configObjet = new wxMenuItem(menuConfig, ID_CONFIG, _("&Preferences"), _("Configure POLSC"));
	configObjet->SetBitmap(wxBitmap(_T("images/preferences-system.png")));
	menuConfig->Append(configObjet);
	wxMenuItem *langObjet = new wxMenuItem(menuConfig, ID_LANGUE, _("Language"), _("Change the user's language"));
	langObjet->SetBitmap(wxBitmap(_T("images/preferences-desktop-locale.png")));
	menuConfig->Append(langObjet);
	menuBarFenp->Append(menuConfig, _("&Configuration"));*/
	
	menuHelp = new wxMenu;
	menuHelp->Append(wxID_HELP, _("&Help online"));
	menuHelp->Append(wxID_ABOUT, _("&About"));
	menuBarFenp->Append(menuHelp, _("&Help"));
		
	SetMenuBar(menuBarFenp);
	
}

void Fenp::About(wxCommandEvent& WXUNUSED(event))
{
	wxInitAllImageHandlers();
	wxAboutDialogInfo aboutDialog;
	ShowLicenceText();
	wxIcon logoPOLSC = wxIcon(_T("images/playonlinux2.png"));
   	aboutDialog.SetName(_T("PolScriptCreator"));
    aboutDialog.SetVersion(_T("0.1"));
    aboutDialog.SetDescription(_("PlayOnLinux's Script Creator"));
    aboutDialog.SetCopyright(_T("© Zoloom 2007\nUnder GPL version 3 licence"));
    aboutDialog.AddDeveloper(_("Zoloom (Cassarin-Grand Arthur)\n"));
    aboutDialog.AddDeveloper(_("Thanks to : Xavier Perrissoud"));
    aboutDialog.AddArtist(_("Icons : Tango Project"));
    aboutDialog.SetWebSite(_T("http://www.playonlinux.com/"),wxEmptyString);
	aboutDialog.SetLicence(bufferTextLicence);
    aboutDialog.SetIcon(logoPOLSC);
    wxAboutBox(aboutDialog);
}

void Fenp::CloseFenpFrame(wxCloseEvent &event)
{
	if (txtcMainBuffer->GetValue() != _T(""))
	{
		if(wxMessageBox(_("Quit without saving ?"), _("POLSC"), wxICON_QUESTION|wxYES_NO) == wxNO)
		{
			return;
		}
		
		else
		{
			exit(0);
		}
	}
	
	else
	{
		exit(0);
	}
}

void Fenp::Quit(wxCommandEvent& WXUNUSED(event))
{
	if (txtcMainBuffer->GetValue() != _T(""))
	{
		if(wxMessageBox(_("Quit without saving ?"), _("POLSC"), wxICON_QUESTION|wxYES_NO) == wxNO)
		{
			return;
		}
		
		else
		{
			exit(0);
		}
	}
	
	else
	{
		exit(0);
	}
}

wxChar* Fenp::GetHome()
{	
	wxChar *tcharHomeUser = wxGetenv("$HOME");
	return tcharHomeUser;
}


void Fenp::New(wxCommandEvent& WXUNUSED(event))
{
	Fennew *fennew = new Fennew(this);
	fennew->Show(true);
	
	/*txtcMainBuffer->SetValue(_T(""));
	wxString textsAddedBufferNew = _T("");
	wxString bufferTextNew = _T("");
	wxString txtsHomeDirectory = GetHome();
	
	wxMessageBox(txtsHomeDirectory,"");
	char bufferFileNewBaseData[2048] = _T("");
	int readLinesNewBaseData = 0;
	ifstream fileNewData(_T("data/new"),ios::in);
	
	while(fileNewData.getline(bufferFileNewBaseData,2048) && !fileNewData.eof())
	{
		if (readLinesNewBaseData == 0)
		{
				bufferTextNew = bufferTextNew + bufferFileNewBaseData;
				readLinesNewBaseData++;
		}
			
		else
		{
				bufferTextNew = bufferTextNew + _T("\n");
				bufferTextNew = bufferTextNew + bufferFileNewBaseData;
				readLinesNewBaseData++;
		}			
	}
				
	fileNewData.close();	

	txtcMainBuffer->AppendText(bufferTextNew);
	txtcMainBuffer->AppendText(_T("\n\n"));
	txtcMainBuffer->AppendText(_T("presentation \"Name of the Game\" \"Editor\" \"Web Site\" \"Your nickname\" \"Short name of the game without spaces\""));*/
}

void Fenp::Open(wxCommandEvent& WXUNUSED(event))
{
	char bufferFileOpen[2048];
	int readLines = 0;
	
	
	nameFileOpen = wxFileSelector(_("Original File") , _T("") ,_T("") ,_T(""),_("*"),wxOPEN);
	ifstream fileOpened(nameFileOpen, ios::in);
	
	if (nameFileOpen == _T(""))
	{
		return;
	}
	
	if (!fileOpened && nameFileOpen != _T(""))
	{
		wxMessageBox(_("The target file don't exist or is unreadable."), _("Erreur POLSC - 01"), wxICON_ERROR);
		return;
	}
	
	else
	{
		txtcMainBuffer->SetValue(_T(""));
		
		while(fileOpened.getline(bufferFileOpen,2048) && !fileOpened.eof())
		{
			if (readLines == 0)
			{
				bufferText = bufferText + bufferFileOpen;
				readLines++;
			}
			
			else
			{
				bufferText = bufferText + _T("\n");
				bufferText = bufferText + bufferFileOpen;
				readLines++;
			}			
		}
			
		
		txtcMainBuffer->SetValue(_T(""));
		txtcMainBuffer->AppendText(bufferText);
		
		fileOpened.close();
						
		fileCurrent = nameFileOpen;
	}
}

void Fenp::Save(wxCommandEvent& WXUNUSED(event))
{
	bufferFileSaved = txtcMainBuffer->GetValue();
	
	if (fileCurrent != _T(""))
	{
		ofstream fileSaved(fileCurrent, ios::out);
		
		if (!fileSaved)
		{
			wxMessageBox(_("The target file don't exist or is unreadable."), _("Erreur POLSC - 01"), wxICON_ERROR);
			return;
		}	
		
		else 
		{
			fileSaved << bufferFileSaved;
		}
		
		fileSaved.close();
		SetStatusText("Save done.");
		
	}
	
	else
	{
		fileCurrent = wxFileSelector(_("Save"), _T(""), _T(""), _T(""), _T("*"), wxSAVE);
		ofstream fileSaved(fileCurrent, ios::out);
			
		if (fileCurrent == _T(""))	
		{
			return;
		}
		
		
		if (!fileSaved && fileCurrent != _T(""))
		{
			wxMessageBox(_T("The target file don't exist or is unreadable."), _("Erreur POLSC - 01"), wxICON_ERROR);
			return;
		}		
			
		else 
		{
			fileSaved << bufferFileSaved;
		}
		
		SetStatusText("Save done.");
		fileSaved.close();
	}	
}

void Fenp::SaveCurrent()
{
	bufferFileSaved = txtcMainBuffer->GetValue();
		
	ofstream fileSaved(_T("/tmp/currentpolsc"), ios::out);
			
	fileSaved << bufferFileSaved;
	
	fileSaved.close();	
}

void Fenp::SaveAs(wxCommandEvent& WXUNUSED(event))
{
	fileCurrent = wxFileSelector(_("Save as..."),_T(""), _T(""), _T(""), _T("*"), wxSAVE);
	ofstream fileSavedAs(fileCurrent, ios::out);
	
	if (fileCurrent == _T(""))
	{
		return;
	}
		
	if (!fileSavedAs && fileCurrent != _T(""))
	{
		wxMessageBox(_("The target file don't exist or is unreadable."), _("Erreur POLSC - 01"), wxICON_ERROR);
		return;
	}		
			
	else 
	{
		fileSavedAs << bufferFileSaved;
	}
	
	SetStatusText("Save done.");
	fileSavedAs.close();
}

void Fenp::HelpOnline(wxCommandEvent& WXUNUSED(event))
{
	wxLaunchDefaultBrowser(_T("http://www.playonlinux.com/en/forums.html"),0);
}

void Fenp::ConfigurePOLSC(wxCommandEvent& WXUNUSED(event))
{
	Fenconfig *fenconfig = new Fenconfig(fenp);
	fenconfig->Show(true);
}

void Fenp::UpScript(wxCommandEvent& WXUNUSED(event))
{
	Fenupscript *fenupscript = new Fenupscript(fenp);
	fenupscript->Show(true);
/*
	wxHTTP http;
	
	wxString txtsBoundary = _T("test");
	wxString txtsBufferScript = _T("");
	wxString txtsNameUser = _T("pseudo");
	wxString txtsValueNameUser = _T("Zoloom");
	wxString txtsPasswordUser = _T("pass");
	wxString txtsValuePasswordUser = _T("pouet");
	wxString txtsNameFile = _T("message");
	wxString txtsValueNameFile = _T("LICENCE");
	wxString txtsValueFile = _T("Coucou tout le monde");
	char txtchBufferReceiveData[1025];
	wxString txtsDataHttp = _T("");
	
	http.SetHeader(_T("Content-type"),wxT("multipart/form-data; boundary=") + txtsBoundary);
	txtsBufferScript.Append(wxString::Format(_T("--%s\r\n"),txtsBoundary.c_str()));
	txtsBufferScript.Append(wxString::Format(_T("Content-Disposition: form-data; name=\"%s\"\r\n\r\n"),txtsNameUser.c_str()));
	txtsBufferScript.Append(wxString::Format(_T("%s\r\n"),txtsValueNameUser.c_str()));
	

	txtsBufferScript.Append(wxString::Format(_T("--%s\r\n"),txtsBoundary.c_str()));
	txtsBufferScript.Append(wxString::Format(_T("Content-Disposition: form-data; password=\"%s\"\r\n\r\n"),txtsPasswordUser.c_str()));
	txtsBufferScript.Append(wxString::Format(_T("%s\r\n"),txtsValuePasswordUser.c_str()));
	

	
	txtsBufferScript.Append(wxString::Format(_T("--%s\r\n"),txtsBoundary.c_str()));
	txtsBufferScript.Append(wxString::Format(_T("Content-Disposition: form-data; name=\"%s\"; filename=\"%s\"\r\n"),txtsNameFile.c_str(),txtsValueNameFile.c_str()));
	txtsBufferScript.Append(_T("Content-Type: text/plain\r\n\r\n"));
	txtsBufferScript.Append(txtsValueFile);
	txtsBufferScript.Append(_T("\r\n"));
	txtsBufferScript.Append(wxString::Format(_T("\r\n--%s--\r\n"),txtsBoundary.c_str()));
	

	cout << txtsBufferScript;
	http.SetPostBuffer(txtsBufferScript);
	http.SetTimeout(120);
	
	
	
	if (http.Connect(_T("playonlinux.com"),80))
	{
		
		if (wxInputStream *streamSite=http.GetInputStream(_T("/script_files/polsc/send.php") ) )
		{
			
			streamSite->Read(txtchBufferReceiveData,1024);
			
        	while (streamSite->LastRead())
			{
			
           	 	txtchBufferReceiveData[streamSite->LastRead()]='\0';
           	 	txtsDataHttp += wxString::FromAscii(txtchBufferReceiveData);
            	streamSite->Read(txtchBufferReceiveData,1024);
        
			}
			
			delete streamSite;	
		}
	}
	
	else
	{
		wxMessageBox("marche pas","POLSC");
	}
	
	wxString txtResult;
	txtResult = SetValue(txtsDataHttp);
	
	cout << txtchBufferReceiveData;
	
*/
}

void Fenp::RunScript(wxCommandEvent& WXUNUSED(event))
{
	wxDir dirPOLExist;
	wxString txtsBashDefaultTrue = _T("export PLAYONLINUX=\"/usr/share/playonlinux\" && bash ");
	wxString txtsBashDefaultFalse1 = _T("export PLAYONLINUX=\"");
	wxString txtsBashDefaultFalse2 = _T("\" && bash ");
	wxString txtsFileRun = _T("");
	wxString txtsPolDirectory = _T("");
	wxString txtsBashCommandRun = _T("");
	
	if (dirPOLExist.Exists(_T("/usr/share/playonlinux")) == true)
	{
		SaveCurrent();
		txtsFileRun = _T("/tmp/currentpolsc");
		txtsBashCommandRun = txtsBashDefaultTrue + txtsFileRun;
		popen(txtsBashCommandRun.c_str(),"r");
	}
	
	else
	{
		if(wxMessageBox(_("PlayOnLinux is not installed in your computer. Do you want to chose PlayOnLinux's directory path ?"), _("POLSC"), wxICON_QUESTION|wxYES_NO) == wxNO)
		{
			return;
		}
		
		else
		{
			txtsPolDirectory = wxDirSelector(_("Choose POL Directory"));
			SaveCurrent();
			txtsFileRun = _T("data/current");
			txtsBashCommandRun = txtsBashDefaultFalse1 + txtsPolDirectory + txtsBashDefaultFalse2 + txtsFileRun;
			popen(txtsBashCommandRun.c_str(),_T("r"));
		}
	}
		
	
}

void Fenp::ShowLicenceText()
{	
	char bufferLicenceOpen[2048];
	ifstream fileLicenceOpen(_T("LICENCE"), ios::in);
	
	while(fileLicenceOpen.getline(bufferLicenceOpen,2048) && !fileLicenceOpen.eof())
	{
			bufferTextLicence = bufferTextLicence + _T("\n");
			bufferTextLicence = bufferTextLicence + bufferLicenceOpen;
	}
		
	fileLicenceOpen.close();	
}

void Fenp::FindAndReplaceDialogShow(wxCommandEvent& WXUNUSED(event))
{
	//dialogFindReplace =  wxFindReplaceDialog(fenp, wxFindReplaceData* data, _("Chercher / Remplacer"));
}

void Fenp::CatchAddedFunctionFromFent(wxString textsCatchAddedBuffer)
{
	txtcMainBuffer->AppendText(textsCatchAddedBuffer);
	SetStatusText("Function writed successfuly.");
}

void Fenp::CatchAddedFunctionFromFennew(wxString textsCatchAddedBufferNew)
{
	txtcMainBuffer->SetValue(_T(""));
	txtcMainBuffer->AppendText(textsCatchAddedBufferNew);
	SetStatusText("Function writed successfuly."); 
}

void Fenp::FunctionChangeDirectory(wxCommandEvent& WXUNUSED(event))
{		
	wxArrayString arrayNomArg;
	arrayNomArg.Add(_("Directory path (between \"\")"));
	arrayNomArg.Add(_("Parameters"));
	Fent *fencd = new Fent(this, _("Change the current directory"), _("This function change your current directory"), _T("cd") , arrayNomArg);
	fencd->Show(true);
}

void Fenp::FunctionMoveFile(wxCommandEvent& WXUNUSED(event))
{		
	wxArrayString arrayNomArg;
	arrayNomArg.Add(_("File to move (between \"\")"));
	arrayNomArg.Add(_("Destination (between \"\")"));
	arrayNomArg.Add(_("Parameters"));
	Fent *fenmove = new Fent(this, _("Move a file or a directory"), _("This function move a file or a directory. Add -r if the object is a directory."), _T("mv") , arrayNomArg);
	fenmove->Show(true);
}

void Fenp::FunctionCopyFile(wxCommandEvent& WXUNUSED(event))
{		
	wxArrayString arrayNomArg;
	arrayNomArg.Add(_("File to copy (between \"\")"));
	arrayNomArg.Add(_("Destination (between \"\")"));
	arrayNomArg.Add(_("Parameters"));
	Fent *fencopy = new Fent(this, _("Change the current directory"), _("This function copy a file or a directory. Add -r if the object is a directory. You can change his name with adding the new name at the end of the destination"), _T("cp") , arrayNomArg);
	fencopy->Show(true);
}

void Fenp::FunctionRemoveFile(wxCommandEvent& WXUNUSED(event))
{		
	wxArrayString arrayNomArg;
	arrayNomArg.Add(_("File to delete (between \"\")"));
	arrayNomArg.Add(_("Parameters"));
	Fent *fenrm = new Fent(this, _("Remove a file"), _("This function remove a file or a directory. Add -r if the object is a directory."), _T("rm") , arrayNomArg);
	fenrm->Show(true);
}

void Fenp::FunctionSelectPrefix(wxCommandEvent& WXUNUSED(event))
{
	wxArrayString arrayNomArg;
	arrayNomArg.Add(_("Prefix's Path (between \"\")"));
	Fent *fenselect_prefixe = new Fent(this, _("Select a prefix"), _("Select (als cd) a current directory, which contains the game's data."), _T("select_prefixe") , arrayNomArg);
	fenselect_prefixe->Show(true);
}

void Fenp::FunctionCreatePrefix(wxCommandEvent& WXUNUSED(event))
{
	wxArrayString arrayNomArg;
	arrayNomArg.Add(_("Current Step"));
	arrayNomArg.Add(_("Maximal Step"));
	Fent *fencreer_prefixe = new Fent(this, _("Create a prefix"), _("Crate a prefix. A prefix is a directory wich contain game data."), _T("creer_prefixe") , arrayNomArg);
	fencreer_prefixe->Show(true);
}

void Fenp::FunctionAskToCDROM(wxCommandEvent& WXUNUSED(event))
{
	wxArrayString arrayNomArg;
	arrayNomArg.Add(_("Current Step"));
	arrayNomArg.Add(_("Maximal Step"));
	Fent *fenAsk_For_cdrom = new Fent(this, _("Ask for CDROM"), _("Ask to user to insert his CD/DVD-ROM and mount it."), _T("Ask_For_cdrom") , arrayNomArg);
	fenAsk_For_cdrom->Show(true);
}

void Fenp::FunctionCheckCDROM(wxCommandEvent& WXUNUSED(event))
{
	wxArrayString arrayNomArg;
	arrayNomArg.Add(_("Launch File"));
	Fent *fenCheck_cdrom = new Fent(this, _("Check the CDROM"), _("Verify if the DVD/CD-ROM is readable, and if the launcher is executable."), _T("Check_cdrom") , arrayNomArg);
	fenCheck_cdrom->Show(true);
}

void Fenp::FunctionStartExe(wxCommandEvent& WXUNUSED(event))
{
	wxArrayString arrayNomArg;
	arrayNomArg.Add(_("Executable"));
	arrayNomArg.Add(_("Parameters"));
	Fent *fenwine = new Fent(this, _("Start Executable with Wine"), _("Start an executable with Wine. Parameters are optionnal."), _T("wine") , arrayNomArg);
	fenwine->Show(true);
}

void Fenp::FunctionAddStarter(wxCommandEvent& WXUNUSED(event))
{
	wxArrayString arrayNomArg;
	arrayNomArg.Add(_("Prefix (between \"\")"));
	arrayNomArg.Add(_("Directory of installation (between \"\")"));
	arrayNomArg.Add(_("Launch executable (between \"\")"));
	arrayNomArg.Add(_("Icon (between \"\")"));
	arrayNomArg.Add(_("Name of the Game (between \"\")"));
	Fent *fencreer_lanceur = new Fent(this, _("Add a launcher"), _("Add a launcher to POL main menu."), _T("creer_lanceur") , arrayNomArg);
	fencreer_lanceur->Show(true);
}

void Fenp::FunctionSimulateReboot(wxCommandEvent& WXUNUSED(event))
{
	wxArrayString arrayNomArg;
	arrayNomArg.Add(_("Current Step"));
	arrayNomArg.Add(_("Maximal Step"));
	Fent *fensimuler_reboot  = new Fent(this, _("Simulate Reboot"), _("Equivalent of rebooting on Windows (don't restart your Linux System, but just reload Wine configuration)."), _T("simuler_reboot") , arrayNomArg);
	fensimuler_reboot ->Show(true);
}

void Fenp::FunctionAssignWineVersion(wxCommandEvent& WXUNUSED(event))
{
	wxArrayString arrayNomArg;
	arrayNomArg.Add(_("Version of Wine (between \"\")"));
	arrayNomArg.Add(_("Prefix to assign (between \"\")"));
	Fent *fensimuler_reboot  = new Fent(this, _("Assign a version of Wine"), _("Assign a version of Wine, just for this prefix. Lot of Windows's Games are more playable with different version. Updating Wine don't change assign version of the script."), _T("Set_WineVersion_Assign") , arrayNomArg);
	fensimuler_reboot ->Show(true);
}

void Fenp::FunctionSetOS(wxCommandEvent& WXUNUSED(event))
{
	wxArrayString arrayNomArg;
	arrayNomArg.Add(_("OS assigned (between \"\") Value : \"vista\",\"winxp\",\"win2k\",\"winnt\",\"winme\",\"win98\",\"win95\",\"win31\""));
	Fent *fenSetOS  = new Fent(this, _("Assign a Windows OS"), _("Assign a Windows OS to the prefix. Some games work better with some OS."), _T("Set_OS") , arrayNomArg);
	fenSetOS ->Show(true);
}

void Fenp::FunctionRegedit(wxCommandEvent& WXUNUSED(event))
{
	wxArrayString arrayNomArg;
	arrayNomArg.Add(_("*.reg file to assign (between \"\")"));
	Fent *fenregedit  = new Fent(this, _("Add a reg file to the prefix"), _("Add the content of a .reg file to the prefix registry."), _T("regedit") , arrayNomArg);
	fenregedit ->Show(true);
}

void Fenp::FunctionMessage(wxCommandEvent& WXUNUSED(event))
{
	wxArrayString arrayNomArg;
	arrayNomArg.Add(_("Message (between \"\")"));
	arrayNomArg.Add(_("Title (between \"\")"));
	arrayNomArg.Add(_("Current Step"));
	arrayNomArg.Add(_("Maximal Step"));
	arrayNomArg.Add(_("Cancel Button (1 : Yes ; 0 : No)"));
	arrayNomArg.Add(_("Image to show (between \"\")"));
	arrayNomArg.Add(_("Text to set for the Next button"));
	Fent *fenmessage  = new Fent(this, _("Show a message dialog"), _("Show a PlayOnLinux's message dialog to the user."), _T("message") , arrayNomArg);
	fenmessage ->Show(true);
}

void Fenp::FunctionWarning(wxCommandEvent& WXUNUSED(event))
{
	wxArrayString arrayNomArg;
	arrayNomArg.Add(_("Message (between \"\")"));
	arrayNomArg.Add(_("Title (between \"\")"));
	arrayNomArg.Add(_("Current Step"));
	arrayNomArg.Add(_("Maximal Step"));
	arrayNomArg.Add(_("Cancel Button (1 : Yes ; 0 : No)"));
	arrayNomArg.Add(_("Image to show (between \"\")"));
	arrayNomArg.Add(_("Text to set for the Next button"));
	Fent *fenwarning  = new Fent(this, _("Show a warning dialog"), _("Show a PlayOnLinux's warning dialog to the user."), _T("warning") , arrayNomArg);
	fenwarning ->Show(true);
}

void Fenp::FunctionError(wxCommandEvent& WXUNUSED(event))
{
	wxArrayString arrayNomArg;
	arrayNomArg.Add(_("Message (between \"\")"));
	arrayNomArg.Add(_("Title (between \"\")"));
	arrayNomArg.Add(_("Current Step"));
	arrayNomArg.Add(_("Maximal Step"));
	arrayNomArg.Add(_("Cancel Button (1 : Yes ; 0 : No)"));
	arrayNomArg.Add(_("Image to show (between \"\")"));
	arrayNomArg.Add(_("Text to set for the Next button"));
	Fent *fenerror  = new Fent(this, _("Show an error dialog"), _("Show an PlayOnLinux's error dialog to the user."), _T("error") , arrayNomArg);
	fenerror ->Show(true);
}

void Fenp::FunctionAskQuestion(wxCommandEvent& WXUNUSED(event))
{
	wxArrayString arrayNomArg;
	arrayNomArg.Add(_("Message (between \"\")"));
	arrayNomArg.Add(_("Title (between \"\")"));
	arrayNomArg.Add(_("Current Step"));
	arrayNomArg.Add(_("Maximal Step"));
	arrayNomArg.Add(_("Cancel Button (1 : Yes ; 0 : No)"));
	arrayNomArg.Add(_("Image to show (between \"\")"));
	Fent *fenquestion  = new Fent(this, _("Ask a yes/no question"), _("Ask a yes no question to the user. This function will return 0 if yes and 1 if no."), _T("question") , arrayNomArg);
	fenquestion ->Show(true);
}

void Fenp::FunctionAskValue(wxCommandEvent& WXUNUSED(event))
{
	wxArrayString arrayNomArg;
	arrayNomArg.Add(_("Message (between \"\")"));
	arrayNomArg.Add(_("Default Value (between \"\")"));
	arrayNomArg.Add(_("Current Step"));
	arrayNomArg.Add(_("Maximal Step"));
	arrayNomArg.Add(_("Cancel Button (1 : Yes ; 0 : No)"));
	arrayNomArg.Add(_("Title (between \"\")"));
	arrayNomArg.Add(_("Image to show (between \"\")"));
	Fent *fenchamp  = new Fent(this, _("Ask a value"), _("Ask a value to the user. This function will return entered value"), _T("champ") , arrayNomArg);
	fenchamp ->Show(true);
}

void Fenp::FunctionSetSound(wxCommandEvent& WXUNUSED(event))
{
	wxArrayString arrayNomArg;
	arrayNomArg.Add(_("Audio library (between \"\") (value : \"alsa\" , \"oss\")"));
	Fent *fenSet_SoundDriver  = new Fent(this, _("Set an audio driver"), _("Set an audio driver to a prefixe. Some game's sound work better with alsa or oss."), _T("Set_SoundDriver") , arrayNomArg);
	fenSet_SoundDriver ->Show(true);
}

void Fenp::FunctionSetManage(wxCommandEvent& WXUNUSED(event))
{
	wxArrayString arrayNomArg;
	arrayNomArg.Add(_("Activate ? (between \"\") (value : \"On\" , \"Off\")"));
	Fent *fenSet_Managed  = new Fent(this, _("Allow Wine to manage windows"), _("Allow Wine to manage desktop's windows"), _T("Set_Managed") , arrayNomArg);
	fenSet_Managed ->Show(true);
}

void Fenp::FunctionSetDXGrab(wxCommandEvent& WXUNUSED(event))
{
	wxArrayString arrayNomArg;
	arrayNomArg.Add(_("Activate ? (between \"\") (value : \"On\" , \"Off\")"));
	Fent *fenSet_DXGrab  = new Fent(this, _("Allow DirectX to catch cursor"), _("Allow DirectX to catch the cursor"), _T("Set_DXGrab") , arrayNomArg);
	fenSet_DXGrab ->Show(true);
}

void Fenp::FunctionSetGLSL(wxCommandEvent& WXUNUSED(event))
{
	wxArrayString arrayNomArg;
	arrayNomArg.Add(_("Activate ? (between \"\") (value : \"On\" , \"Off\")"));
	Fent *fenSet_GLSL  = new Fent(this, _("Activate GLSL"), _("Activate GLSL"), _T("Set_GLSL") , arrayNomArg);
	fenSet_GLSL ->Show(true);
}

void Fenp::FunctionBrowseFile(wxCommandEvent& WXUNUSED(event))
{
	wxArrayString arrayNomArg;
	arrayNomArg.Add(_("Current Step"));
	arrayNomArg.Add(_("Maximal Step"));
	Fent *fenselect_file  = new Fent(this, _("Ask file path"), _("Ask a file path to the user. This function return the path, you can catch this value with a variable."), _T("select_file") , arrayNomArg);
	fenselect_file ->Show(true);
}

void Fenp::FunctionDownload(wxCommandEvent& WXUNUSED(event))
{
	wxArrayString arrayNomArg;
	arrayNomArg.Add(_("Message (between \"\")"));
	arrayNomArg.Add(_("Url to download (between \"\")"));
	arrayNomArg.Add(_("Destination in hard disk (between \"\")"));
	arrayNomArg.Add(_("Title (between \"\")"));
	arrayNomArg.Add(_("Current Step"));
	arrayNomArg.Add(_("Maximal Step"));
	arrayNomArg.Add(_("Cancel Button (1 : Yes ; 0 : No)"));
	arrayNomArg.Add(_("Image to show (between \"\")"));
	arrayNomArg.Add(_("Auto exit after downloading (1 : Yes ; 0 : No)"));
	arrayNomArg.Add(_("Start download automaticly (1 : Yes ; 0 : No)"));
	
	Fent *fenselect_file  = new Fent(this, _("Download a file"), _("Show a progress dialog and download a file."), _T("download") , arrayNomArg);
	fenselect_file ->Show(true);
}



BEGIN_EVENT_TABLE( Fenp, wxFrame)

EVT_MENU(wxID_NEW, Fenp::New)
EVT_MENU(wxID_OPEN, Fenp::Open)
EVT_MENU(wxID_ABOUT, Fenp::About)
EVT_MENU(wxID_SAVE, Fenp::Save)
EVT_MENU(wxID_SAVEAS, Fenp::SaveAs)
EVT_MENU(wxID_HELP, Fenp::HelpOnline)
//EVT_MENU(ID_CONFIG, Fenp::ConfigurePOLSC)
//EVT_MENU(ID_UPSCRIPT, Fenp::UpScript)
EVT_MENU(ID_RUNSCRIPT, Fenp::RunScript)
EVT_MENU(wxID_EXIT, Fenp::Quit)

EVT_MENU(ID_FCD, Fenp::FunctionChangeDirectory)
EVT_MENU(ID_FMV, Fenp::FunctionMoveFile)
EVT_MENU(ID_FCOPY, Fenp::FunctionCopyFile)
EVT_MENU(ID_FRM, Fenp::FunctionRemoveFile)
EVT_MENU(ID_SPX, Fenp::FunctionSelectPrefix)
EVT_MENU(ID_CPX, Fenp::FunctionCreatePrefix)
EVT_MENU(ID_ASKV, Fenp::FunctionAskValue)
EVT_MENU(ID_ASKCD, Fenp::FunctionAskToCDROM)
EVT_MENU(ID_CHECKCD, Fenp::FunctionCheckCDROM)
EVT_MENU(ID_STARTEXE, Fenp::FunctionStartExe)
EVT_MENU(ID_ADDSTARTER, Fenp::FunctionAddStarter)
EVT_MENU(ID_SIMREBOOT, Fenp::FunctionSimulateReboot)
EVT_MENU(ID_ASSIGNWINE, Fenp::FunctionAssignWineVersion)
EVT_MENU(ID_SETOS, Fenp::FunctionSetOS)
EVT_MENU(ID_REGEDIT, Fenp::FunctionRegedit)
EVT_MENU(ID_MESSAGE, Fenp::FunctionMessage)
EVT_MENU(ID_WARNING, Fenp::FunctionWarning)
EVT_MENU(ID_ERROR, Fenp::FunctionError)
EVT_MENU(ID_QUESTION, Fenp::FunctionAskQuestion)
EVT_MENU(ID_CHAMP, Fenp::FunctionAskValue)
EVT_MENU(ID_SETSOUND, Fenp::FunctionSetSound)
EVT_MENU(ID_SETMANAGE, Fenp::FunctionSetManage)
EVT_MENU(ID_SETDXGRAB, Fenp::FunctionSetDXGrab)
EVT_MENU(ID_SETGLSL, Fenp::FunctionSetGLSL)
EVT_MENU(ID_BROWSFILE, Fenp::FunctionBrowseFile)
EVT_MENU(ID_DOWNLOAD, Fenp::FunctionDownload)

EVT_CLOSE(Fenp::CloseFenpFrame)

END_EVENT_TABLE()


