/*Copyright (C) 2007 Cassarin-Grand Arthur (Zoloom)

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA. */

#ifndef FENP_H_INCLUDED
#define FENP_H_INCLUDED

#include <wx/wx.h>
#include <iostream>
#include <string>
#include <fstream>
#include <dirent.h>

#include <wx/textdlg.h>
#include <wx/textctrl.h> 
#include <wx/stattext.h>
#include <wx/toolbar.h>
#include <wx/sizer.h>
#include <wx/file.h>
#include <wx/textctrl.h>
#include <wx/msgdlg.h>
#include <wx/process.h> 
#include <wx/msgdlg.h>
#include <wx/event.h> 
#include <wx/arrstr.h>
#include <wx/wxprec.h>
#include <wx/dirdlg.h>
#include <wx/statbmp.h>
#include <wx/listbox.h>
#include <wx/dir.h>
#include <wx/splash.h>
#include <wx/spinctrl.h>
#include <wx/panel.h>
#include <wx/notebook.h>
#include <wx/intl.h>
#include <wx/stream.h>
#include <wx/radiobox.h>
#include <wx/busyinfo.h>
#include <wx/utils.h> 
#include <wx/aboutdlg.h>
#include <wx/fdrepdlg.h>
#include <wx/menu.h>
#include <wx/protocol/http.h>
#include <wx/dir.h>
#include <wx/image.h>
#include <wx/richtext/richtextctrl.h>

#pragma once

class Fenp : public wxFrame 
{ 
	private:
		
		//Menus
		
		wxMenu* menuFile;
		wxMenu* menuExecution;
		wxMenu* menuFonctions;
		wxMenu* menuConfig;
		wxMenu* menuHelp;
	
		//Sous-menus
	
		wxMenu* subMenuFilesDirectory;
		wxMenu* subMenuWineVersions;
		wxMenu* subMenuWinePrefixe;
		wxMenu* subMenuCDDVDROM;
		wxMenu* subMenuGeneral;
		wxMenu* subMenuDialog;
	
		//Tool Bar
	
		wxToolBar* toolBarFenp;
	
		//Status Bar
	
		wxStatusBar *statusbFenp;
	
		//Zone de texte
		
		wxTextCtrl *txtcMainBuffer;
	
		//Box
	
		wxBoxSizer *boxFenp;
		wxBoxSizer *boxStatusFenp;
		wxBoxSizer *boxMainBuffer;
	
		//FindDialog
	
		wxFindReplaceDialog dialogFindReplace;
	
		//Variables GUI
	
		wxString nameFileOpen;
		std::string bufferText;
		std::string bufferFileOpen;
		wxString nomFileSave;
		wxString bufferFileSaved;
		wxString fileCurrent;
	
		wxString textsCatchAddedBuffer;
		wxString textsCatchAddedBufferNew;
		wxString textsAddedBufferNew;
	
		Fenp *fenp;
		wxString bufferTextLicence;
		wxString bufferTextNew;
		
		DECLARE_EVENT_TABLE()
		
	public:
		
		Fenp();
		~Fenp();
	
		void About(wxCommandEvent& WXUNUSED(event));
		void New(wxCommandEvent& WXUNUSED(event));	
		void Open(wxCommandEvent& WXUNUSED(event));	
		void Save(wxCommandEvent& WXUNUSED(event));	
		void SaveCurrent();
		void SaveAs(wxCommandEvent& WXUNUSED(event));
		void CloseFenpFrame(wxCloseEvent &event);
		void HelpOnline(wxCommandEvent& WXUNUSED(event));
		void ConfigurePOLSC(wxCommandEvent& WXUNUSED(event));
		void UpScript(wxCommandEvent& WXUNUSED(event));
		void FindAndReplaceDialogShow(wxCommandEvent& WXUNUSED(event));
		void CatchAddedFunctionFromFent(wxString textsCatchAddedBuffer);
		void CatchAddedFunctionFromFennew(wxString textsCatchAddedBufferNew);
		void ShowLicenceText();
		void RunScript(wxCommandEvent& WXUNUSED(event));
		void Quit(wxCommandEvent& WXUNUSED(event));
		wxChar* GetHome();
	
		//Fonctions
	
		void FunctionCd(wxCommandEvent& WXUNUSED(event));
		void FunctionChangeDirectory(wxCommandEvent& WXUNUSED(event));
		void FunctionMoveFile(wxCommandEvent& WXUNUSED(event));
		void FunctionCopyFile(wxCommandEvent& WXUNUSED(event));
		void FunctionRemoveFile(wxCommandEvent& WXUNUSED(event));
		void FunctionSelectPrefix(wxCommandEvent& WXUNUSED(event));
		void FunctionCreatePrefix(wxCommandEvent& WXUNUSED(event));
		void FunctionAskToCDROM(wxCommandEvent& WXUNUSED(event));
		void FunctionCheckCDROM(wxCommandEvent& WXUNUSED(event));
		void FunctionStartExe(wxCommandEvent& WXUNUSED(event));
		void FunctionAddStarter(wxCommandEvent& WXUNUSED(event));
		void FunctionSimulateReboot(wxCommandEvent& WXUNUSED(event));
		void FunctionAssignWineVersion(wxCommandEvent& WXUNUSED(event));
		void FunctionSetOS(wxCommandEvent& WXUNUSED(event));
		void FunctionRegedit(wxCommandEvent& WXUNUSED(event));
		void FunctionMessage(wxCommandEvent& WXUNUSED(event));
		void FunctionWarning(wxCommandEvent& WXUNUSED(event));
		void FunctionError(wxCommandEvent& WXUNUSED(event));
		void FunctionAskQuestion(wxCommandEvent& WXUNUSED(event));
		void FunctionAskValue(wxCommandEvent& WXUNUSED(event));
		void FunctionSetSound(wxCommandEvent& WXUNUSED(event));
		void FunctionSetManage(wxCommandEvent& WXUNUSED(event));
		void FunctionSetDXGrab(wxCommandEvent& WXUNUSED(event));
		void FunctionSetGLSL(wxCommandEvent& WXUNUSED(event));
		void FunctionBrowseFile(wxCommandEvent& WXUNUSED(event));
		void FunctionDownload(wxCommandEvent& WXUNUSED(event));

	
	protected:
		
		void CreateMenuFenp();
			
};

#endif

