/*Copyright (C) 2007 Cassarin-Grand Arthur (Zoloom)

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA. */


#include "Fent.h"
#include "Fenp.h"
#include "Fenconfig.h"
#include "Fennew.h"
#include "Fenupscript.h"

using namespace std;

Fent::Fent(wxWindow *parent, wxString stextTitle, wxString stextDescription, wxString stextCommand, wxArrayString &arrayNomArg) : wxFrame(parent, wxID_ANY, stextTitle, wxDefaultPosition, wxSize(500,-1)) 
{
	
	SetBackgroundColour(wxSystemSettings::GetColour(wxSYS_COLOUR_3DFACE));
	wxIcon icoFenp(_T("images/list-add.png")); //declaration de l'icone
	SetIcon(icoFenp); //on le lie a la fenetre
	
	nombreArg = arrayNomArg.GetCount();
	
	if (nombreArg > 13)
	{
		cout << _T("Too much arguments given") << endl;
		return;
	}
	
	else
	{
		boxMainArg = new wxBoxSizer(wxVERTICAL);
		
		textsDescription = new wxStaticText(this, -1, stextDescription, wxDefaultPosition, wxDefaultSize);
		textsDescription->Wrap(400);
		boxTextsDescription = new wxBoxSizer(wxHORIZONTAL);
			boxTextsDescription->Add(textsDescription, 0, wxALIGN_CENTER_HORIZONTAL, 5);
			boxMainArg->Add(boxTextsDescription, 0, 5);	
				
		txtcArg[0] = new wxTextCtrl(this, -1, _T(""), wxDefaultPosition, wxDefaultSize, wxTE_READONLY);
		txtcArg[0]->SetValue(stextCommand);
		boxsArg[0] = new wxStaticBoxSizer(wxHORIZONTAL, this, _("Syntax"));
			boxsArg[0]->Add(txtcArg[0], 1, wxLEFT | wxEXPAND, 5);
			boxMainArg->Add(boxsArg[0], 0, wxEXPAND, 10);
		
		if (nombreArg >= 1)
		{
			txtcArg[1] = new wxTextCtrl(this, -1, _T(""), wxDefaultPosition, wxDefaultSize);
			boxsArg[1] = new wxStaticBoxSizer(wxHORIZONTAL, this, arrayNomArg[0]);
				boxsArg[1]->Add(txtcArg[1], 1, wxLEFT | wxEXPAND, 5);
				boxMainArg->Add(boxsArg[1], 0, wxEXPAND, 5);
		}
		
		if (nombreArg >= 2)
		{
			txtcArg[2] = new wxTextCtrl(this, -1, _T(""), wxDefaultPosition, wxDefaultSize);
			boxsArg[2] = new wxStaticBoxSizer(wxHORIZONTAL, this, arrayNomArg[1]);
				boxsArg[2]->Add(txtcArg[2], 1, wxLEFT | wxEXPAND, 5);
				boxMainArg->Add(boxsArg[2], 0, wxEXPAND, 10);
		}
		
		if (nombreArg >= 3)
		{
			txtcArg[3] = new wxTextCtrl(this, -1, _T(""), wxDefaultPosition, wxDefaultSize);
			boxsArg[3] = new wxStaticBoxSizer(wxHORIZONTAL, this, arrayNomArg[2]);
				boxsArg[3]->Add(txtcArg[3], 1, wxLEFT | wxEXPAND, 5);
				boxMainArg->Add(boxsArg[3], 0, wxEXPAND, 10);
		}
		
		if (nombreArg >= 4)
		{
			txtcArg[4] = new wxTextCtrl(this, -1, _T(""), wxDefaultPosition, wxDefaultSize);
			boxsArg[4] = new wxStaticBoxSizer(wxHORIZONTAL, this, arrayNomArg[3]);
				boxsArg[4]->Add(txtcArg[4], 1, wxLEFT | wxEXPAND, 5);
				boxMainArg->Add(boxsArg[4], 0, wxEXPAND, 10);
		}
		
		if (nombreArg >= 5)
		{
			txtcArg[5] = new wxTextCtrl(this, -1, _T(""), wxDefaultPosition, wxDefaultSize);
			boxsArg[5] = new wxStaticBoxSizer(wxHORIZONTAL, this, arrayNomArg[4]);
				boxsArg[5]->Add(txtcArg[5], 1, wxLEFT | wxEXPAND, 5);
				boxMainArg->Add(boxsArg[5], 0, wxEXPAND, 10);
		}
		
		if (nombreArg >= 6)
		{
			txtcArg[6] = new wxTextCtrl(this, -1, _T(""), wxDefaultPosition, wxDefaultSize);
			boxsArg[6] = new wxStaticBoxSizer(wxHORIZONTAL, this, arrayNomArg[5]);
				boxsArg[6]->Add(txtcArg[6], 1, wxLEFT | wxEXPAND, 5);
				boxMainArg->Add(boxsArg[6], 0, wxEXPAND, 10);
		}
		
		if (nombreArg >= 7)
		{
			txtcArg[7] = new wxTextCtrl(this, -1, _T(""), wxDefaultPosition, wxDefaultSize);
			boxsArg[7] = new wxStaticBoxSizer(wxHORIZONTAL, this, arrayNomArg[6]);
				boxsArg[7]->Add(txtcArg[7], 1, wxLEFT | wxEXPAND, 5);
				boxMainArg->Add(boxsArg[7], 0, wxEXPAND, 10);
		}
		
		if (nombreArg >= 8)
		{
			txtcArg[8] = new wxTextCtrl(this, -1, _T(""), wxDefaultPosition, wxDefaultSize);
			boxsArg[8] = new wxStaticBoxSizer(wxHORIZONTAL, this, arrayNomArg[7]);
				boxsArg[8]->Add(txtcArg[8], 1, wxLEFT | wxEXPAND, 5);
				boxMainArg->Add(boxsArg[8], 0, wxEXPAND, 10);
		}
		
		if (nombreArg >= 9)
		{
			txtcArg[9] = new wxTextCtrl(this, -1, _T(""), wxDefaultPosition, wxDefaultSize);
			boxsArg[9] = new wxStaticBoxSizer(wxHORIZONTAL, this, arrayNomArg[8]);
				boxsArg[9]->Add(txtcArg[9], 1, wxLEFT | wxEXPAND, 5);
				boxMainArg->Add(boxsArg[9], 0, wxEXPAND, 10);
		}
		
		if (nombreArg >= 10)
		{
			txtcArg[10] = new wxTextCtrl(this, -1, _T(""), wxDefaultPosition, wxDefaultSize);
			boxsArg[10] = new wxStaticBoxSizer(wxHORIZONTAL, this, arrayNomArg[9]);
				boxsArg[10]->Add(txtcArg[10], 1, wxLEFT | wxEXPAND, 5);
				boxMainArg->Add(boxsArg[10], 0, wxEXPAND, 10);
		}
		
		if (nombreArg >= 11)
		{
			txtcArg[11] = new wxTextCtrl(this, -1, _T(""), wxDefaultPosition, wxDefaultSize);
			boxsArg[11] = new wxStaticBoxSizer(wxHORIZONTAL, this, arrayNomArg[10]);
				boxsArg[11]->Add(txtcArg[11], 1, wxLEFT | wxEXPAND, 5);
				boxMainArg->Add(boxsArg[11], 0, wxEXPAND, 10);
		}
		
		if (nombreArg == 12)
		{
			txtcArg[12] = new wxTextCtrl(this, -1, _T(""), wxDefaultPosition, wxDefaultSize);
			boxsArg[12] = new wxStaticBoxSizer(wxHORIZONTAL, this, arrayNomArg[11]);
				boxsArg[12]->Add(txtcArg[12], 1, wxLEFT | wxEXPAND, 5);
				boxMainArg->Add(boxsArg[12], 0, wxEXPAND, 10);
		}
				
	buttonAddFunction = new wxButton(this, 119, _("Add to source code"), wxDefaultPosition, wxDefaultSize);
	boxButtonArg = new wxBoxSizer(wxHORIZONTAL);
		boxButtonArg->Add(buttonAddFunction, 0, wxALIGN_CENTER_HORIZONTAL, 5);
		boxMainArg->Add(boxButtonArg, 0, wxALIGN_CENTER_HORIZONTAL, 10);	
		
	SetSizerAndFit(boxMainArg);
	
	
	
	//((Fenp*) GetParent())->AddTextToBuffer(_T("Pouët !"));
	}
}


 
Fent::~Fent()
{
	
}

void Fent::AddTextToBuffer(wxCommandEvent& WXUNUSED(event))
{
	
	wxString textsAddedBuffer = _T("");
	
	wxString textsArgToAddToBuffer[13];
	
	textsArgToAddToBuffer[0] = txtcArg[1]->GetValue();
	
	if (nombreArg >= 2)
		textsArgToAddToBuffer[1] = txtcArg[2]->GetValue();
	if (nombreArg >= 3)
		textsArgToAddToBuffer[2] = txtcArg[3]->GetValue();
	if (nombreArg >= 4)
		textsArgToAddToBuffer[3] = txtcArg[4]->GetValue();
	if (nombreArg >= 5)
		textsArgToAddToBuffer[4] = txtcArg[5]->GetValue();
	if (nombreArg >= 6)
		textsArgToAddToBuffer[5] = txtcArg[6]->GetValue();
	if (nombreArg >= 7)
		textsArgToAddToBuffer[6] = txtcArg[7]->GetValue();
	if (nombreArg >= 8)
		textsArgToAddToBuffer[7] = txtcArg[8]->GetValue();
	if (nombreArg >= 9)
		textsArgToAddToBuffer[8] = txtcArg[9]->GetValue();
	if (nombreArg >= 10)
		textsArgToAddToBuffer[9] = txtcArg[10]->GetValue();
	if (nombreArg >= 11)
		textsArgToAddToBuffer[10] = txtcArg[11]->GetValue();
	if (nombreArg >= 12)
		textsArgToAddToBuffer[11] = txtcArg[12]->GetValue();
	
	for (int i=0;i<=nombreArg;i++)
	{
		textsAddedBuffer.Append(txtcArg[i]->GetValue());
		textsAddedBuffer = textsAddedBuffer + _T(" ");
	}
	
	Fenp* parent=(Fenp*)GetParent();
	
	textsAddedBuffer = textsAddedBuffer + _T("\n");
	parent->CatchAddedFunctionFromFent(textsAddedBuffer);


}

BEGIN_EVENT_TABLE( Fent, wxFrame)

EVT_BUTTON(119, Fent::AddTextToBuffer)

END_EVENT_TABLE()

