#!/usr/bin/env python
# -*- coding: utf-8 -*-

# Copyright (C) 2007 Pâris Quentin
#  		     Cassarin-Grand Arthur

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA. 

import wxversion, os, getopt, sys, urllib, signal
wxversion.select("2.8")
import wx

class Variables():
	playonlinux_env = os.popen("printf \"$PLAYONLINUX\"", "r").read()
	playonlinux_rep = os.popen("printf \"$HOME/.PlayOnLinux/\"", "r").read()

class Lng(): # Read language file
	# File
	run = os.popen("printf \"$LNG_MAIN_MENU_ITEM_PLAY\"", "r").read()
	install = os.popen("printf \"$LNG_MAIN_MENU_ITEM_INSTALL\"", "r").read()
	remove = os.popen("printf \"$LNG_MAIN_MENU_ITEM_REMOVE\"", "r").read()
	file_menu = os.popen("printf \"$LNG_MAIN_MENU\"", "r").read()
	update = os.popen("printf \"$LNG_MAIN_MENU_ITEM_UPDATE\"", "r").read()
	choose_game = os.popen("printf \"$LNG_CHOOSE_GAME\"", "r").read()

	# Expert
	expert =  os.popen("printf \"$LNG_MAIN_MENU_ITEM_EXPERT\"", "r").read()
	expert_wineconfig =  os.popen("printf \"$LNG_EXPERT_WINECONFIG\"", "r").read()
	expert_regedit =  os.popen("printf \"$LNG_EXPERT_REGISTRY\"", "r").read()
	expert_wineprefix =  os.popen("printf \"$LNG_EXPERT_WINEPREFIX\"", "r").read()
	expert_directx =  os.popen("printf \"$LNG_EXPERT_DIRECTX\"", "r").read()
	expert_wver =  os.popen("printf \"$LNG_EXPERT_WVER\"", "r").read()
	expert_run =  os.popen("printf \"$LNG_EXPERT_RUN\"", "r").read()

	# Option 
	option = os.popen("printf \"$LNG_OPTIONS_MENU\"", "r").read()
	option_tests =  os.popen("printf \"$LNG_OPTIONS_TESTS\"", "r").read()
	option_language =  os.popen("printf \"$LNG_OPTIONS_LANGUAGE\"", "r").read()
	option_repository =  os.popen("printf \"$LNG_OPTIONS_REPOSITORY\"", "r").read()
	option_panels =  os.popen("printf \"$LNG_OPTIONS_PANELS\"", "r").read()
	option_informations = os.popen("printf \"$LNG_INFORMATION\"", "r").read()

	#Other
	error = os.popen("printf \"$LNG_ERROR\"", "r").read()
	exit = os.popen("printf \"$LNG_EXIT\"", "r").read()
	about = os.popen("printf \"$LNG_ABOUT\"", "r").read()
	help = os.popen("printf \"$LNG_HELP\"", "r").read()
	refresh = os.popen("printf \"$LNG_REFRESH\"", "r").read() 

class MainWindow(wx.Frame):
  def __init__(self,parent,id,title):
    wx.Frame.__init__(self, parent, -1, title, size = (520, 500))
    self.SetIcon(wx.Icon(Variables.playonlinux_env+"/etc/playonlinux.png", wx.BITMAP_TYPE_ANY))
    self.timer = wx.Timer(self, 1)

    self.filemenu = wx.Menu()
    self.filemenu.Append(wx.ID_OPEN, Lng.run)
    self.filemenu.Append(wx.ID_ADD, Lng.install)
    self.filemenu.Append(wx.ID_DELETE, Lng.remove)
    self.filemenu.Append(wx.ID_REFRESH, Lng.update)
    self.filemenu.AppendSeparator()
    self.filemenu.Append(wx.ID_EXIT, Lng.exit)

    self.expertmenu = wx.Menu()
  
    self.wineconfig_item = wx.MenuItem(self.expertmenu, 102, Lng.expert_wineconfig)
    self.wineconfig_item.SetBitmap(wx.Bitmap(Variables.playonlinux_env+"/etc/menu/wine.png"))
    self.expertmenu.AppendItem(self.wineconfig_item)

    self.regedit_item = wx.MenuItem(self.expertmenu, 103, Lng.expert_regedit)
    self.regedit_item.SetBitmap(wx.Bitmap(Variables.playonlinux_env+"/etc/menu/regedit.png"))
    self.expertmenu.AppendItem(self.regedit_item)

    self.wineprefix_item = wx.MenuItem(self.expertmenu, 104, Lng.expert_wineprefix)
    self.wineprefix_item.SetBitmap(wx.Bitmap(Variables.playonlinux_env+"/etc/menu/wineprefix.png"))
    self.expertmenu.AppendItem(self.wineprefix_item)

    self.directx_item = wx.MenuItem(self.expertmenu, 106, Lng.expert_directx)
    self.directx_item.SetBitmap(wx.Bitmap(Variables.playonlinux_env+"/etc/menu/directx.png"))
    self.expertmenu.AppendItem(self.directx_item)

    self.winever_item = wx.MenuItem(self.expertmenu, 107, Lng.expert_wver)
    self.winever_item.SetBitmap(wx.Bitmap(Variables.playonlinux_env+"/etc/menu/wine.png"))
    self.expertmenu.AppendItem(self.winever_item)

    self.run_item = wx.MenuItem(self.expertmenu, 108, Lng.expert_run)
    self.run_item.SetBitmap(wx.Bitmap(Variables.playonlinux_env+"/etc/menu/run.png"))
    self.expertmenu.AppendItem(self.run_item)

    self.polshell_item = wx.MenuItem(self.expertmenu, 109, "PolShell")
    self.polshell_item.SetBitmap(wx.Bitmap(Variables.playonlinux_env+"/etc/menu/polshell.png"))
    self.expertmenu.AppendItem(self.polshell_item)

    self.optionmenu = wx.Menu()

    self.tests_item = wx.MenuItem(self.expertmenu, 110, Lng.option_tests)
    self.tests_item.SetBitmap(wx.Bitmap(Variables.playonlinux_env+"/etc/menu/test.png"))
    self.optionmenu.AppendItem(self.tests_item)

    self.lng_item = wx.MenuItem(self.expertmenu, 111, Lng.option_language)
    self.lng_item.SetBitmap(wx.Bitmap(Variables.playonlinux_env+"/etc/menu/lang.png"))
    self.optionmenu.AppendItem(self.lng_item)

    self.repos_item = wx.MenuItem(self.expertmenu, 112, Lng.option_repository)
    self.repos_item.SetBitmap(wx.Bitmap(Variables.playonlinux_env+"/etc/menu/repository.png"))
    self.optionmenu.AppendItem(self.repos_item)

    self.panel_item = wx.MenuItem(self.expertmenu, 113, Lng.option_panels)
    self.panel_item.SetBitmap(wx.Bitmap(Variables.playonlinux_env+"/etc/menu/panel.png"))
    self.optionmenu.AppendItem(self.panel_item)

    self.infos_item = wx.MenuItem(self.expertmenu, 114, Lng.option_informations)
    self.infos_item.SetBitmap(wx.Bitmap(Variables.playonlinux_env+"/etc/menu/infos.png"))
    self.optionmenu.AppendItem(self.infos_item)

    self.helpmenu = wx.Menu()
    self.helpmenu.Append(wx.ID_ABOUT, Lng.about)

    self.menubar = wx.MenuBar()
    self.menubar.Append(self.filemenu, Lng.file_menu)
    self.menubar.Append(self.expertmenu, Lng.expert)
    self.menubar.Append(self.optionmenu, Lng.option)
    self.menubar.Append(self.helpmenu, Lng.help)
    self.SetMenuBar(self.menubar)

    self.toolbar = self.CreateToolBar(wx.TB_TEXT)
    self.toolbar.AddLabelTool(wx.ID_OPEN, Lng.run, wx.ArtProvider.GetBitmap("gtk-open", wx.ART_TOOLBAR))
    self.toolbar.AddLabelTool(wx.ID_ADD, Lng.install, wx.ArtProvider.GetBitmap("gtk-add", wx.ART_TOOLBAR))
    self.toolbar.AddLabelTool(wx.ID_DELETE, Lng.remove, wx.ArtProvider.GetBitmap("gtk-delete", wx.ART_TOOLBAR))
    self.toolbar.AddLabelTool(wx.ID_REFRESH, Lng.update, wx.ArtProvider.GetBitmap("gtk-refresh", wx.ART_TOOLBAR))
    self.toolbar.AddLabelTool(101, Lng.refresh, wx.ArtProvider.GetBitmap("gtk-refresh", wx.ART_TOOLBAR))

    self.images = wx.ImageList(32, 32)
    self.list_game = wx.TreeCtrl(self, 105, style=wx.TR_HIDE_ROOT|wx.TR_FULL_ROW_HIGHLIGHT)
    self.list_game.SetSpacing(0);
    self.list_game.SetImageList(self.images)

    self.Reload(self)

    wx.EVT_MENU(self, wx.ID_OPEN,  self.Run)
    wx.EVT_MENU(self, wx.ID_ADD,  self.InstallMenu)
    wx.EVT_MENU(self, wx.ID_ABOUT,  self.About)
    wx.EVT_MENU(self,  wx.ID_EXIT,  self.ClosePol)
    wx.EVT_MENU(self,  wx.ID_REFRESH,  self.UpdatePol)
    wx.EVT_MENU(self,  wx.ID_DELETE,  self.UninstallGame)

    # Expert
    wx.EVT_MENU(self, 101,  self.Reload)
    wx.EVT_MENU(self, 102,  self.ConfigureWine)
    wx.EVT_MENU(self, 103,  self.Regedit)
    wx.EVT_MENU(self, 104,  self.UpdatePrefixe)
    wx.EVT_MENU(self, 106,  self.DirectX)
    wx.EVT_MENU(self, 107,  self.WineVersion)
    wx.EVT_MENU(self, 108,  self.Executer)
    wx.EVT_MENU(self, 109,  self.PolShell)

    #Options
    wx.EVT_MENU(self, 110,  self.Tests)
    wx.EVT_MENU(self, 111,  self.Lng_choose)
    wx.EVT_MENU(self, 112,  self.Repository)
    wx.EVT_MENU(self, 113,  self.Panels)
    wx.EVT_MENU(self, 114,  self.Informations)
    wx.EVT_TREE_ITEM_ACTIVATED(self, 105, self.Run)

    #Timer, regarde toute les secondes si il faut actualiser la liste
    self.Bind(wx.EVT_TIMER, self.AutoReload, self.timer)
    self.timer.Start(1000)
	
  def Tests(self, event):
    print("Running test")
    os.system("bash \""+Variables.playonlinux_env+"/bash/options/tests\"&")

  def Lng_choose(self, event):
    print("Running lng_choose")
    os.system("bash \""+Variables.playonlinux_env+"/bash/options/lng_choose\"&")

  def Repository(self, event):
    print("Running repository")
    os.system("bash \""+Variables.playonlinux_env+"/bash/options/repository\"&")
  
  def Panels(self, event):
    print("Running panel")
    os.system("bash \""+Variables.playonlinux_env+"/bash/options/panel\"&")

  def Informations(self, event):
    print("Running informations menu")
    os.system("bash \""+Variables.playonlinux_env+"/bash/options/infos\"&")

  def DirectX(self, event):
    game_exec = self.list_game.GetItemText(self.list_game.GetSelection())
    if(game_exec != ""):
        print("Running DirectX Setup")
   	os.system("bash \""+Variables.playonlinux_env+"/bash/expert/DirectX\" \""+game_exec+"\"&")
    else:
	error = wx.MessageDialog(self, Lng.choose_game,"Erreur", wx.OK | wx.ICON_ERROR)
        error.ShowModal()
        error.Destroy()

  def UpdatePrefixe(self, event):
    game_exec = self.list_game.GetItemText(self.list_game.GetSelection())
    if(game_exec != ""):
        print("Running wineprefixecreate")
   	os.system("bash \""+Variables.playonlinux_env+"/bash/expert/UpdatePrefixe\" \""+game_exec+"\"&")
    else:
	error = wx.MessageDialog(self, Lng.choose_game,"Erreur", wx.OK | wx.ICON_ERROR)
        error.ShowModal()
        error.Destroy()

  def Executer(self, event):
    print("Running exec")
    os.system("bash \""+Variables.playonlinux_env+"/bash/expert/Executer\"&")

  def PolShell(self, event):
    print("Running PolShell")
    os.system("bash \""+Variables.playonlinux_env+"/bash/expert/PolShell\"&")

  def Regedit(self, event):
    game_exec = self.list_game.GetItemText(self.list_game.GetSelection())
    if(game_exec != ""):
        print("Running regedit")
   	os.system("bash \""+Variables.playonlinux_env+"/bash/expert/BaseDeRegistre\" \""+game_exec+"\"&")
    else:
	error = wx.MessageDialog(self, Lng.choose_game,Lng.error, wx.OK | wx.ICON_ERROR)
        error.ShowModal()
        error.Destroy()

  def UninstallGame(self, event):
    game_exec = self.list_game.GetItemText(self.list_game.GetSelection())
    if(game_exec != ""):
        print("Uninstall "+game_exec)
   	os.system("bash \""+Variables.playonlinux_env+"/bash/uninstall\" \""+game_exec+"\"&")

    else:
	error = wx.MessageDialog(self, Lng.choose_game,Lng.error, wx.OK | wx.ICON_ERROR)
        error.ShowModal()
        error.Destroy()

  def ConfigureWine(self, event):
    game_exec = self.list_game.GetItemText(self.list_game.GetSelection())
    if(game_exec != ""):
        print("Running wineconfig")
   	os.system("bash \""+Variables.playonlinux_env+"/bash/expert/WineConfig\" \""+game_exec+"\"&")
    else:
	error = wx.MessageDialog(self, Lng.choose_game,Lng.error, wx.OK | wx.ICON_ERROR)
        error.ShowModal()
        error.Destroy()


  def AutoReload(self, event):
    reload = os.popen("bash \""+Variables.playonlinux_env+"/bash/reload\"", "r").read()
    if(reload == "1"):
	self.Reload(self)

  def Reload(self, event):
    game_exec = self.list_game.GetItemText(self.list_game.GetSelection())
    self.games = os.listdir(Variables.playonlinux_rep+"configurations/installed/")
    self.games.sort()
    self.images.RemoveAll()
    for game in self.games: #METTRE EN 32x32
	if(os.path.exists(Variables.playonlinux_rep+"/icones/32/"+game)):
		file_icone = Variables.playonlinux_rep+"/icones/32/"+game
	else:
		file_icone = Variables.playonlinux_rep+"/icones/32/playonlinux.png"
	self.images.Add(wx.Bitmap(file_icone));

    self.list_game.DeleteAllItems()
    root = self.list_game.AddRoot("")
    
    self.i = 0
    for game in self.games:
	self.list_game.AppendItem(root, game, self.i)
	self.i = self.i+1


  def InstallMenu(self, event):
    print("Running install menu")
    os.system("bash \""+Variables.playonlinux_env+"/bash/install\"&")
    
  def UpdatePol(self, event):
    print("Running update menu")
    os.system("bash \""+Variables.playonlinux_env+"/bash/check_maj\"&")

  def WineVersion(self, event):
    print("Running wineversion menu")
    os.system("bash \""+Variables.playonlinux_env+"/bash/wineversion\"&")

  def Run(self, event):
    game_exec = self.list_game.GetItemText(self.list_game.GetSelection())
    if(game_exec != ""):
	print("Running "+game_exec)
	os.system("cd \""+Variables.playonlinux_rep+"/configurations/installed/\" && bash \""+game_exec+"\"&")
    else:
	error = wx.MessageDialog(self, Lng.choose_game,Lng.error, wx.OK | wx.ICON_ERROR)
        error.ShowModal()
        error.Destroy()

  def ClosePol(self, event):
    self.Close()
    
  def About(self, event):
    self.aboutBox = wx.AboutDialogInfo()
    self.aboutBox.SetName("PlayOnLinux")
    self.aboutBox.SetVersion("2.0.0")
    self.aboutBox.SetDescription("Jouer à vos jeux Windows sous Linux !")
    self.aboutBox.SetCopyright("(C) L'équipe PlayOnLinux 2007\nSous licence GPL version 3")
    self.aboutBox.AddDeveloper("Tinou (Pâris Quentin)")
    self.aboutBox.AddDeveloper("Goku (Picaut Antoine)")
    self.aboutBox.AddDeveloper("MulX")
    self.aboutBox.AddDeveloper("Zoloom (Cassarin-Grand Arthur)")
    self.aboutBox.AddDeveloper("kiplantt")	 
    self.aboutBox.AddArtist("Les logos sont issus des projets Tango et Crystal Project")
    self.aboutBox.AddArtist("Logo : Skely") 
    self.aboutBox.AddArtist("Fenêtres designés par Asimov")	
    self.aboutBox.SetWebSite("http://www.playonlinux.com")
        
    wx.AboutBox(self.aboutBox);
    

class PlayOnLinuxApp(wx.App):
   def OnInit(self):
        MySplash = SplashScreen()
        MySplash.Show()

        return True

class SplashScreen(wx.SplashScreen):
    def __init__(self, parent=None):
        # This is a recipe to a the screen.
        # Modify the following variables as necessary.
        aBitmap = wx.Image(name = Variables.playonlinux_env+"/etc/splash.png").ConvertToBitmap()
        splashStyle = wx.SPLASH_CENTRE_ON_SCREEN | wx.SPLASH_TIMEOUT
        splashDuration = 1000 # milliseconds
        # Call the constructor with the above arguments in exactly the
        # following order.
        wx.SplashScreen.__init__(self, aBitmap, splashStyle,
                                 splashDuration, parent)
        self.Bind(wx.EVT_CLOSE, self.OnExit)

        wx.Yield()

    def OnExit(self, evt):
        self.Hide()
        # MyFrame is the main frame.
        frame = MainWindow(None, -1, "PlayOnLinux")
        app.SetTopWindow(frame)
	frame.Center(wx.BOTH)
        frame.Show(True)
        # The program will freeze without this line.
        evt.Skip()  # Make sure the default handler runs too...

app = PlayOnLinuxApp()
app.MainLoop()
